﻿<# 
   .SYNOPSIS 
    Adds a digital signature to a file

   .DESCRIPTION
    Uses a code signing certificate located in the user store to digitally sign a file.
     
   .NOTES
    AUTHOR: Dawn Wertz
    
    VERSION: 1.0.0.0
    DATE: 07-Jul-2018
    
    CHANGE LOG: 
    1.0.0.0 : 07-Jul-2018  : Initial version of script 
    
   .LINK
    https://configgirl.com
#> 

[CmdletBinding()]
Param(
  [Parameter(Mandatory=$True)]
   [string]$FileName,
	
   [Parameter(Mandatory=$False)]
   [ValidateSet("CurrentUser","LocalMachine")]
   [string]$Location = "CurrentUser"

)

$cert = Get-ChildItem "cert:\$Location\my" -CodeSigningCert
If($cert)
{
    $timeStampURL = "http://timestamp.verisign.com/scripts/timstamp.dll"
    if(Test-Path ($FileName))
    {
        Set-AuthenticodeSignature -filepath $FileName -cert $cert -TimeStampServer $timeStampURL
        Write-Host "$File was successfully signed."
    }
    Else
    {
        Write-Host "File $filename was not found"
    }
}
Else
{
    Write-Host "Code Signing Certificate not found in $Location certificate store"
}